import os
import argparse
import subprocess
from tqdm import tqdm

def main():
    parser = argparse.ArgumentParser(description="process files in the folder,with eval_script to eval")
    parser.add_argument("--input_dir", type=str, required=True, help="folder to process")
    parser.add_argument("--annotation_path", type=str, required=True, help="COCO innotions,for eval_script")
    parser.add_argument("--desc_key", type=str, default="caption", help="field name to be evaled, for eval_script")
    parser.add_argument("--output_prefix", type=str, default="chair_output", help="for eval_script--output_dir")
    parser.add_argument("--eval_script", type=str, default="tci/eval/eval_chair.py", help="path")
    parser.add_argument("--filter_ext", type=str, default=".json", help="check json file")
    args = parser.parse_args()

    # check input folder
    if not os.path.isdir(args.input_dir):
        print(f"WRONG: input folder'{args.input_dir}' does't exist")
        return

    # check evaluate.py
    if not os.path.isfile(args.eval_script):
        print(f"WRONG: eval script'{args.eval_script}' does't exist")
        return

    # get all json files in the folder
    file_list = []
    for filename in os.listdir(args.input_dir):
        file_path = os.path.join(args.input_dir, filename)
        # process file
        if os.path.isfile(file_path):
            if not args.filter_ext or filename.endswith(args.filter_ext):
                file_list.append(file_path)

    if not file_list:
        print(f"WARNING: can't find files in'{args.input_dir}'")
        return

    # process files
    print(f"find {len(file_list)}files, begin ...")
    for file_path in tqdm(file_list, desc="processing"):
        try:
            cmd = [
                "python", args.eval_script,
                "--cap_file", file_path,
                "--annotation_path", args.annotation_path,
                "--desc_key", args.desc_key,
                "--output_dir", args.output_prefix
            ]
            
            result = subprocess.run(
                cmd,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
                text=True
            )

            if result.returncode != 0:
                print(f"process file'{file_path}' failed:")
                print(result.stderr)
            else:
                print(f"'process {file_path}' succeed:")
                print(result.stdout)
                pass

        except Exception as e:
            print(f"something wrong when processing '{file_path}': {str(e)}")

    print(f"ALL DONE!")

if __name__ == "__main__":
    main()